create database LMS_Assignment;
use LMS_Assignment;
create table Employee (Employee_ID int ,Employee_name varchar(30),Project_ID int ,Department varchar(30),Salary int,Experience int,Projects varchar(30));
insert into Employee values (1,'Mohit',2,'IT',50000,2,'project "A"'),
(2,'Reema',3,'Sales',30000,1,'project "B"'),
(3,'Harish',2,'IT',50000,2,'Project "A"'),
(4,'Paras',2,'IT',95000,4,'Project "A"'),
(5,'Shivam',1,'HR',77000,4,'Project "C"'),
(6,'Harish',3,'Sales',30000,1,'Project "B"'),
(7,'Dorthy',1,'HR',65000,3,'Project "c"'),
(8,'Archana',3,'Sales',18000,Null,'Project "B"')
,(9,'Vishal',3,'Sales',18000,Null,'Project "B"'),
(10,'Shubendu',1,'HR',150000,8,'Project "C"'),
(11,'Drigga',4,'Finance',48000,3,'Project "D"'),
(12,'Maninder',2,'IT',145000,7,'Project "A"'),
(13,'Nithish',4,'Finance',115000,6,'Project "D"'),
(14,'Shubham',4,'Finance',74000,5,'Project "D"'),
(15,Null,Null,'Finance',17000,Null,Null),
(16,'Prince',Null,Null,Null,Null,Null);
select * from Employee;

create table Project (Performance_ID int,Employee_ID int,Project_ID int,Performance_rating float,Feedback varchar(30));
insert into Project values 
(1,1,2,9,'Excellent'),
(2,2,3,8,'Good'),
(3,3,2,9,'Excellent'),
(4,4,3,9.3,'Excellent'),
(5,5,1,9,'Excellent'),
(6,6,3,8.5,'Good'),
(7,7,1,8,'Good'),
(8,8,3,5,'Average'),
(9,9,3,6,'Average'),
(10,10,1,9.4,'Excellent'),
(11,11,4,7,'Average'),
(12,12,2,9.5,'Average'),
(13,13,4,8.5,'Good'),
(14,14,4,8,'Good'),
(15,15,Null,Null,'Wrost'),
(16,16,NUll,Null,'Wrost');
 select * from Project;

Create table Department (Employee_ID int,Performance_Id int,Manager varchar(30),Manager_ID int,Employee_name varchar(30),Project_ID int, Department varchar(30),Salary int,Experience int,Projects varchar(30));
insert into Department values 
(1,1,'Aizen',1,'Mohit',2,'IT',50000,2,'Project "A"'),
(2,2,'Ichigo',2,'Reema',3,'Sales',30000,1,'Project "B"'),
(3,3,'Aizen',1,'Harish',2,'IT',50000,2,'Project "A"'),
(4,4,'Aizen',1,'Paras',2,'IT',95000,4,'Project "A"'),
(5,5,'Shunsui',3,'Shivam',1,'HR',77000,4,'Project "C"'),
(6,6,'Ichigo',2,'Harsh',3,'Sales',30000,1,'Project "B"'),
(7,7,'Shunsui',3,'Dorthy',1,'HR',65000,3,'Project "C"'),
(8,8,'Ichigo',2,'Archana',3,'Sales',18000,Null,'Project "B"'),
(9,9,'Ichigo',2,'Vishal',3,'Sales',18000,Null,'Project "B"'),
(10,10,'Shunsui',3,'Shubendu',1,'HR',150000,8,'Project "C"'),
(11,11,'Rukia',4,'Drigga',4,'Finance',48000,3,'Project "D"'),
(12,12,'Aizen',1,'Maninder',2,'IT',145000,7,'Project "A"'),
(13,13,'Rukia',4,'Nithish',4,'Finance',115000,6,'Project "D"'),
(14,14,'Rukia',4,'Shubham',4,'Finance',74000,5,'Project "D"'),
(15,15,Null,Null,Null,Null,'Finance',17000,Null,Null),
(16,16,Null,Null,'Prince',Null,Null,Null,Null,Null);
select * from Department;

create table Performance (Performance_ID int,Employee_ID int,Manager_ID int,Project_ID int,Performance_rating float,Feedback varchar(30));
insert into Performance values 
(1,1,1,2,9,'Excellent'),
(2,2,2,3,8,'Good'),
(3,3,1,2,9,'Excellent'),
(4,4,1,3,9.3,'Excellent'),
(5,5,3,1,9,'Excellent'),
(6,6,1,3,8.5,'Good'),
(7,7,3,1,8,'Good'),
(8,8,2,3,5,'Average'),
(9,9,2,3,6,'Average'),
(10,10,3,1,9.4,'Excellent'),
(11,11,4,4,7,'Average'),
(12,12,1,2,9.5,'Average'),
(13,13,4,4,8.5,'Good'),
(14,14,4,4,8,'Good'),
(15,15,Null,Null,Null,'Wrost'),
(16,16,NUll,Null,Null,'Wrost');
select * from Performance;


# Easy Level:-

# Q1. Insert a new employee with the following details: Employee_ID=22, Employee_name='John',Project_ID=1,Department='IT',Salary=50000,Experience=2,Projects='ProjectA'.
	 insert into Employee(Employee_ID,Employee_name,Project_ID,Department,Salary,Experience,Projects) values(22,'John',1,'IT',50000,2,'Project "A"');
      
# Q2. How would you add a new column called "Manager_ID" to the employee table?
      alter table Employee add column Manager_ID int;
      
# Q3. What is the total salary expenditure of the company?
      select sum(Salary) as Total_salary from Employee;
      
# Q4. How many employees are there in each department?
      select Department, count(*)as Total_Employee from Employee group by Department;
      
# Q5. Are there any employees with an Experience of more than 5 years?
      select * from Employee where Experience>5;
      
# Q6. Retrieve the details of employees whose salary is greater than the average salary of all employees.
      select * from Employee where Salary>(select avg (salary) from Employee);
      
# Q7. Add a new project 'ProjectB' for the employee with Employee_id=25.
      insert into Employee(Employee_ID,Projects) values (25,'Project "B"');
      
# Q8. What is the average experiemce of employees in each department?
      select Department,avg(Experience)as average_experience  from Employee group by Department;
      
# Q9. Modify the data type of the Salary column from INT to DECIMAl (10,2). 
      alter table Employee modify column Salary decimal(10,2);
      
# 10. What is the maximum salary among all employees in "IT" department?
      select max(Salary) from Employee where Department='IT';



# Medium Level:-

# Q1. How many employees are there in each department, and what is the maximum salary in each department?
	  select Department, count(Employee_ID),max(Salary) from Employee group by Department;
      
# Q2. Retrive the details of employees whose salary is greater than the highest salary in any other department.
      select * from Employee where Salary>(select max(salary) from Employee where Department != Employee.Department);
      
# Q3. Add a foreign key constraint on the project_id column in the employee table refrencing the  projrct_ID column in the Projects table. 
    alter table Employee add constraint primary key(Project_ID);
    alter table Employee  add constraint Project_ID foreign key (Project_ID) references Project(Project_ID);
    
# Q4. Delete all employees with a salary less than 40000 and Department is "IT"?
     delete from Employee where Salary<40000 and Department='IT' ;
     
# Q5. Retrive the Employee_name,Department,and Performance_rating of all employees along with their respective departments.
	  select Employee_name,Department,Performance_rating from Employee inner join Project on Employee.Employee_ID=Project.Employee_ID;
      
# Q6. Retrieve the employee_name and Feedback for employees with Employee_ID between 11 and 16. 
      select Employee_name,Feedback from Employee inner join Project on Employee.Employee_ID=Project.Employee_ID where Employee.Employee_ID between 11 and 16; ;
      
# Q7. Retrieve Employee_name who have salary more than "50,000", performance_rating greater than "8" from "Sales" Department?
      select Employee_name from Employee inner join Project on Employee.Employee_ID=Project.Employee_ID where Salary>50000 and Performance_rating>8 and Department='Sales';
      
# Q8. Which employee_ID have "Average" Feedback with Project_ID "3".
      select Employee_ID from Project where Feedback='Average' and Project_ID='3';
      
# Q9. Find a employee_name who have who do not have any project with Feedback "Average"?
      select Employee_name from Employee left join Performance on Employee.Employee_ID=Performance.Employee_ID where Feedback!='Average';

# Q10. Retrieve performance_id with the performance_rating above "6" and below "9" with feedback "Good".
	   select Performance_ID from Project where Performance_rating>6 and Performance_rating<9 and Feedback='Good';




# Advance-:

# Q1. Retrieve the Department along with the average Performance_rating for each department.
	  select Department, avg(Performance_rating) from Department inner join Performance on Department.Employee_ID=Performance.Employee_ID group by Department;
      
# Q2. Retrieve the Employee_name, Department, and Performance_rating of employees whose Performance_rating is above 8 and are assigned to project ID 1.
      select Employee_name,Department,Performance_rating from Department inner join Performance on Department.Employee_ID=Performance.Employee_ID 
	  where performance.Performance_rating>8 and Department.Project_ID=1;
      
# Q3. Retrieve all employees along with their performance ratings. If an employee has no performance rating recorded, and mention manager name.
	  select Employee_name,Performance_rating,Manager from Department right join Performance on Department.Employee_ID=Performance.Employee_ID ;
      
# Q4. Retrieve the Employee_name and Performance_rating for employees whose Performance_rating is higher than the average Performance_rating for their respective departments.
      select Employee_name,Performance_rating,Department from Department right join Performance on Department.Employee_ID=Performance.Employee_ID 
      where Performance_rating > (select avg(performance_rating) from Department inner join Performance on Department.Employee_ID=Performance.Employee_ID);

# Q5. Retrieve the Department along with the average Performance_rating for departments having an average Performance_rating greater than 7.
     select Department, avg(Performance_rating) from Department inner join Performance on Department.Employee_ID=Performance.Employee_ID 
     group by Department having avg(Performance_rating)>7;

# Q6. Retrieve the Employee_name and the number of employees who have the same Manager_ID.
	  select Employee_name, count(*)  from Department  group by Department.Manager_ID ;

# Q7. Retrieve the Employee_name for employees who have a corresponding record in the employee_performance table and do not have a manager.
      select Employee_name from Department left join Performance on Department.Employee_ID=Performance.Employee_ID where Department.Employee_ID 
	  in (select Employee_ID from Performance) and Department.Manager_ID is null;

# Q8. Create a temporary table containing the Employee_name and Performance_rating of employees. Then, retrieve the details of employees along with their department names from both the employee table and the temporary table.


# Q9. Retrieve the Employee_name and Department for employees who are assigned to a project with a Project_ID greater than 2.
      select Employee_name,Department from Department where Project_ID>2;

# Q10. Retrieve the Employee_name, Department, and Project_name for employees assigned to projects with manager name “Kurosaki”.
 select Employee_name,Department,Projects from Department where Manager='Kurosaki';


